/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/
#ifndef WAYLANDBACKEND_WLPOINTER
#define WAYLANDBACKEND_WLPOINTER 1

#include <wayland-client.h>

namespace WaylandBackend
{

class WLPointer
{
public:
    WLPointer(struct wl_seat *wlSeat, struct wl_event_queue *eventQ);
    virtual ~WLPointer();

    void clearIfFocusMatches(struct wl_surface *wlSurface);
    
private:
    struct wl_pointer *_wlPointer;
    struct wl_seat *_wlSeat;
    struct wl_surface *_pointerFocus;
    static const struct wl_pointer_listener _pointerListener;

    static void pointerHandleEnter(void* data, struct wl_pointer* wlPointer,
                            uint32_t serial, struct wl_surface* wlSurface,
                            wl_fixed_t sx, wl_fixed_t sy);

    static void pointerHandleMotion(void* data, struct wl_pointer* wlPointer,
                            uint32_t time, wl_fixed_t sx, wl_fixed_t sy);

    static void pointerHandleButton(void* data, struct wl_pointer* wlPointer,
                            uint32_t serial, uint32_t time, uint32_t button,
                            uint32_t state);

    static void pointerHandleAxis(void* data, struct wl_pointer* wlPointer,
                            uint32_t time, uint32_t axis, wl_fixed_t value);

    static void pointerHandleLeave(void* data, struct wl_pointer* wlPointer,
                            uint32_t serial, struct wl_surface* wlSurface);
};

}
#endif
